<?php
require_once __DIR__.'/../inc/auth.php';
require_once __DIR__.'/../inc/db.php';
require_once __DIR__.'/../inc/functions.php';
require_login();
$uid=current_user_id();
$wid=(int)($_GET['id']??0);

$stmt=$pdo->prepare("SELECT * FROM wallets WHERE id=? AND user_id=?");
$stmt->execute([$wid,$uid]);
$w=$stmt->fetch(PDO::FETCH_ASSOC);
if(!$w){ die('Wallet not found'); }

// handle toggle paid
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['toggle_day'])){
  $day=(int)$_POST['toggle_day'];
  $pdo->prepare("UPDATE wallet_plan SET paid = 1 - paid WHERE wallet_id=? AND day_no=?")->execute([$wid,$day]);
  header("Location: view_wallet.php?id=".$wid); exit;
}

// fetch plan
$p=$pdo->prepare("SELECT day_no,amount,paid FROM wallet_plan WHERE wallet_id=? ORDER BY day_no ASC");
$p->execute([$wid]); $plan=$p->fetchAll(PDO::FETCH_ASSOC);

// aggregate
$total=array_sum(array_column($plan,'amount'));
$paid_amt=0; foreach($plan as $r){ if($r['paid']) $paid_amt+=$r['amount']; }
$pct=$total?floor(($paid_amt/$total)*100):0;

require_once __DIR__.'/_header.php';
?>
<div class="bg-white p-6 rounded-2xl glow">
  <div class="flex flex-wrap justify-between gap-3 items-center">
    <div>
      <h1 class="text-2xl font-extrabold mb-1"><?=htmlspecialchars($w['name'])?></h1>
      <div class="text-sm text-gray-600">Goal ₹<?=number_format($w['goal_amount'])?> • Days <?=$w['days']?> • Max/day ₹<?=$w['max_daily']?> • Unit ₹<?=$w['unit']?></div>
      <div class="text-sm mt-1">UPI: <span class="font-medium"><?=htmlspecialchars($w['upi_id'] ?: '—')?></span></div>
    </div>
    <div class="flex items-center gap-4">
      <a class="px-3 py-2 rounded border" href="view_wallet.php?id=<?=$wid?>&export=csv">Export CSV</a>
      <a class="px-3 py-2 rounded bg-yellow-500 text-white" href="generate_plan.php?id=<?=$wid?>">Regenerate Plan</a>
      <a class="px-3 py-2 rounded bg-blue-600 text-white" href="pay_manual.php?id=<?=$wid?>">Pay via UPI</a>
    </div>
  </div>

  <div class="mt-4 grid md:grid-cols-3 gap-4">
    <div class="md:col-span-1 flex items-center justify-center">
      <svg width="140" height="140">
        <circle cx="70" cy="70" r="58" stroke="#E5E7EB" stroke-width="12" fill="none"></circle>
        <circle cx="70" cy="70" r="58" stroke="url(#g1)" stroke-width="12" fill="none"
                stroke-dasharray="<?=2*3.1416*58?>" stroke-dashoffset="<?=2*3.1416*58*(1-$pct/100)?>" class="ring-progress"></circle>
        <defs>
          <linearGradient id="g1" x1="0" y1="0" x2="1" y2="1">
            <stop offset="0%" stop-color="#2563EB"/>
            <stop offset="100%" stop-color="#6D28D9"/>
          </linearGradient>
        </defs>
      </svg>
      <div class="ml-3">
        <div class="text-3xl font-extrabold"><?=$pct?>%</div>
        <div class="text-sm text-gray-600">₹<?=number_format($paid_amt)?> / ₹<?=number_format($total)?></div>
      </div>
    </div>
    <div class="md:col-span-2">
      <canvas id="barChart"></canvas>
      <canvas id="lineChart" class="mt-4"></canvas>
    </div>
  </div>

  <div class="mt-6">
    <h3 class="font-semibold text-lg mb-2">Plan Details</h3>
    <form method="post">
    <table class="w-full text-sm border">
      <thead><tr class="bg-gray-50"><th class="border p-2">Day</th><th class="border p-2">Amount (₹)</th><th class="border p-2">Paid?</th><th class="border p-2">Toggle</th></tr></thead>
      <tbody>
      <?php foreach($plan as $r): ?>
        <tr>
          <td class="border p-2"><?=$r['day_no']?></td>
          <td class="border p-2"><?=$r['amount']?></td>
          <td class="border p-2"><?=$r['paid']?'Yes':'No'?></td>
          <td class="border p-2"><button name="toggle_day" value="<?=$r['day_no']?>" class="px-2 py-1 rounded <?= $r['paid']?'bg-gray-300':'bg-green-600 text-white'?>"><?= $r['paid']?'Undo':'Mark Paid'?></button></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
    </form>
  </div>
</div>

<?php
// charts data
$days = array_column($plan,'day_no');
$amounts = array_column($plan,'amount');
$cum = []; $s=0; foreach($amounts as $a){ $s+=$a; $cum[]=$s; }
?>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const days = <?=json_encode($days)?>;
const amounts = <?=json_encode($amounts)?>;
const cum = <?=json_encode($cum)?>;
new Chart(document.getElementById('barChart').getContext('2d'),{
  type:'bar',
  data:{ labels:days, datasets:[{label:'Daily Deposit (₹)', data:amounts}]},
  options:{ animation:{ duration:800 }, scales:{ y:{ beginAtZero:true } } }
});
new Chart(document.getElementById('lineChart').getContext('2d'),{
  type:'line',
  data:{ labels:days, datasets:[{label:'Cumulative (₹)', data:cum}]},
  options:{ animation:{ duration:800 }, scales:{ y:{ beginAtZero:true } } }
});
</script>

<?php require_once __DIR__.'/_footer.php'; ?>
