<?php
require_once __DIR__.'/../inc/auth.php';
require_once __DIR__.'/../inc/db.php';
require_login();
$uid=current_user_id();
$wid=(int)($_GET['id']??0);
$st=$pdo->prepare("SELECT * FROM wallets WHERE id=? AND user_id=?"); $st->execute([$wid,$uid]); $w=$st->fetch(PDO::FETCH_ASSOC);
if(!$w) die('Wallet not found');
require_once __DIR__.'/_header.php';
?>
<div class="max-w-xl mx-auto bg-white p-6 rounded-2xl glow">
  <h1 class="text-2xl font-bold mb-2">Pay via UPI</h1>
  <p class="text-sm text-gray-600 mb-4">Use this UPI ID to deposit today's amount.</p>
  <div class="p-4 rounded-lg bg-gradient-to-r from-blue-600 to-purple-600 text-white flex justify-between items-center">
    <div class="text-xl font-mono"><?=htmlspecialchars($w['upi_id']?:'UPI not set')?></div>
    <?php if($w['upi_id']): ?>
    <a class="bg-white text-blue-700 px-3 py-2 rounded" href="upi://pay?pa=<?=urlencode($w['upi_id'])?>&pn=Dream%20Wallet">Open UPI</a>
    <?php endif; ?>
  </div>
  <div class="mt-4 text-sm">After paying, go back and <b>Mark Paid</b> for today's day.</div>
</div>
<?php require_once __DIR__.'/_footer.php'; ?>
