<?php
$config = require __DIR__.'/../inc/config.php';
?><!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?=htmlspecialchars($config['site_name'])?></title>
<script src="https://cdn.tailwindcss.com"></script>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
<script>
  tailwind.config = {
    theme: {
      extend: {
        fontFamily: { 'sans': ['Inter','ui-sans-serif','system-ui'] },
        colors: { primary: {DEFAULT:'#6D28D9'}, secondary:'#2563EB' }
      }
    }
  }
</script>
<style>
  .glow{ box-shadow:0 10px 30px rgba(109,40,217,.25); }
  .fade-in{ animation: fade .5s ease-in forwards; opacity:0;}
  @keyframes fade{ to{ opacity:1;}}
  .ring-progress{ transition: stroke-dashoffset .6s ease; }
</style>
</head>
<body class="bg-gradient-to-b from-indigo-50 to-white min-h-screen">
<header class="bg-gradient-to-r from-blue-600 to-purple-600 text-white">
  <div class="max-w-5xl mx-auto px-4 py-5 flex items-center justify-between">
    <div class="text-xl font-extrabold tracking-tight"><?=htmlspecialchars($config['site_name'])?></div>
    <div class="text-sm opacity-90"><?=htmlspecialchars($config['motivation'])?></div>
  </div>
</header>
<main class="max-w-5xl mx-auto px-4 py-6">
